/* This file has been generated by Fred's Fisher Price record creator v2.1.0.0 on 14 Aug 2012 23:34
 * http://www.instructables.com/id/3D-printing-records-for-a-Fisher-Price-toy-record-/
 *
 * Press F6 to view your model in OpenSCAD
 * Then you cn export as STL for printing
 */

// Configuration
$fn = 100;
hStock = 5;
rStock = 60.58;
oDrive = 21.8;
rDrive = 1.55;
hInset = 1;
rInset = 25.6;
hGroove = 1.2;
overlap = 0.2;

hasSecondSide = 1;

// Some very useful code by HarlanDMii
// http://www.thingiverse.com/thing:16193
use <write.scad>

// Create disc
module createDisc() {
	union() {

		createBlank();

		// Add the notes for the song. This part is dynamically generated.
		// Autogenerated pins for music tracks
		pin(27.95,29.15,12.363930987505,0);
		pin(27.95,29.15,34.1821128056868,0);
		pin(27.95,29.15,56.0002946238686,0);
		pin(27.95,29.15,77.8184764420504,0);
		pin(27.95,29.15,99.6366582602322,0);
		pin(27.95,29.15,192.363930987505,0);
		pin(27.95,29.15,214.182112805687,0);
		pin(27.95,29.15,236.000294623869,0);
		pin(27.95,29.15,257.81847644205,0);
		pin(27.95,29.15,279.636658260232,0);
		pin(29.15,30.35,12.4988283020457,0);
		pin(29.15,30.35,56.1351919384093,0);
		pin(29.15,30.35,154.317010120227,0);
		pin(29.15,30.35,192.498828302046,0);
		pin(29.15,30.35,236.135191938409,0);
		pin(29.15,30.35,334.317010120228,0);
		pin(30.69,31.89,143.622151961285,0);
		pin(30.69,31.89,323.622151961285,0);
		pin(31.89,33.09,154.643949733959,0);
		pin(31.89,33.09,334.643949733959,0);
		pin(33.51,34.71,138.468530867402,0);
		pin(33.51,34.71,143.923076321948,0);
		pin(33.51,34.71,318.468530867402,0);
		pin(33.51,34.71,323.923076321948,0);
		pin(34.71,35.91,-3.25451743897088,0);
		pin(34.71,35.91,29.4727552883019,0);
		pin(34.71,35.91,45.8363916519382,0);
		pin(34.71,35.91,127.65457347012,0);
		pin(34.71,35.91,154.927300742847,0);
		pin(34.71,35.91,176.745482561029,0);
		pin(34.71,35.91,209.472755288302,0);
		pin(34.71,35.91,225.836391651938,0);
		pin(34.71,35.91,307.65457347012,0);
		pin(34.71,35.91,334.927300742847,0);
		pin(36.225,37.425,7.80573115211963,0);
		pin(36.225,37.425,24.169367515756,0);
		pin(36.225,37.425,35.0784584248469,0);
		pin(36.225,37.425,51.4420947884833,0);
		pin(36.225,37.425,78.7148220612105,0);
		pin(36.225,37.425,122.351185697574,0);
		pin(36.225,37.425,187.80573115212,0);
		pin(36.225,37.425,204.169367515756,0);
		pin(36.225,37.425,215.078458424847,0);
		pin(36.225,37.425,231.442094788483,0);
		pin(36.225,37.425,258.714822061211,0);
		pin(36.225,37.425,302.351185697574,0);
		pin(37.425,38.625,13.3421054730322,0);
		pin(37.425,38.625,73.3421054730321,0);
		pin(37.425,38.625,116.978469109396,0);
		pin(37.425,38.625,236.978469109396,0);
		pin(37.425,38.625,269.705741836669,0);
		pin(39.025,40.225,57.1153792567359,0);
		pin(39.025,40.225,89.8426519840087,0);
		pin(39.025,40.225,193.479015620372,0);
		pin(39.025,40.225,253.479015620372,0);
		pin(39.025,40.225,297.115379256736,0);
		pin(40.225,41.425,68.0953018599524,0);
		pin(40.225,41.425,111.731665496316,0);
		pin(40.225,41.425,275.36802913268,0);
		pin(41.8,43,95.4855462047319,0);
		pin(41.8,43,248.212818932005,0);
		pin(41.8,43,291.849182568368,0);
		pin(43,44.2,101.002074923118,0);
		pin(44.625,45.825,281.108143911572,0);

		title("STAIRWAY TO HEAVEN",0);

		// Autogenerated pins for music tracks
		pin(27.95,29.15,280.922782299208,1);
		pin(27.95,29.15,159.768936145362,1);
		pin(29.15,30.35,353.480192676975,1);
		pin(29.15,30.35,311.941731138514,1);
		pin(29.15,30.35,232.326346523129,1);
		pin(29.15,30.35,190.787884984668,1);
		pin(29.15,30.35,121.557115753898,1);
		pin(30.69,31.89,76.3428830037497,1);
		pin(30.69,31.89,62.4967291575958,1);
		pin(31.89,33.09,353.153253063244,1);
		pin(31.89,33.09,231.999406909398,1);
		pin(33.51,34.71,363.349650950779,1);
		pin(33.51,34.71,356.426574027703,1);
		pin(33.51,34.71,259.503497104626,1);
		pin(33.51,34.71,242.195804796933,1);
		pin(33.51,34.71,235.272727873856,1);
		pin(33.51,34.71,148.734266335395,1);
		pin(33.51,34.71,138.349650950779,1);
		pin(33.51,34.71,127.965035566164,1);
		pin(33.51,34.71,76.0419586430871,1);
		pin(33.51,34.71,69.1188817200102,1);
		pin(33.51,34.71,27.5804201815487,1);
		pin(34.71,35.91,332.100671285125,1);
		pin(34.71,35.91,300.946825131279,1);
		pin(34.71,35.91,269.792978977432,1);
		pin(34.71,35.91,210.946825131279,1);
		pin(34.71,35.91,179.792978977432,1);
		pin(34.71,35.91,120.946825131279,1);
		pin(34.71,35.91,114.023748208202,1);
		pin(34.71,35.91,110.562209746663,1);
		pin(34.71,35.91,96.7160559005094,1);
		pin(34.71,35.91,79.408363592817,1);
		pin(34.71,35.91,62.1006712851247,1);
		pin(34.71,35.91,55.1775943620478,1);
		pin(34.71,35.91,51.7160559005093,1);
		pin(36.225,37.425,259.257205910817,1);
		pin(36.225,37.425,138.103359756971,1);
		pin(36.225,37.425,75.795667449279,1);
		pin(36.225,37.425,27.3341289877405,1);
		pin(37.425,38.625,352.636915505989,1);
		pin(37.425,38.625,331.867684736758,1);
		pin(37.425,38.625,300.713838582912,1);
		pin(37.425,38.625,231.483069352143,1);
		pin(37.425,38.625,210.713838582912,1);
		pin(37.425,38.625,189.944607813681,1);
		pin(37.425,38.625,158.790761659835,1);
		pin(37.425,38.625,99.9446078136812,1);
		pin(37.425,38.625,51.4830693521427,1);
		pin(39.025,40.225,342.115389974033,1);
		pin(39.025,40.225,310.961543820187,1);
		pin(39.025,40.225,279.807697666341,1);
		pin(39.025,40.225,220.961543820187,1);
		pin(39.025,40.225,200.192313050956,1);
		pin(39.025,40.225,179.423082281726,1);
		pin(39.025,40.225,110.192313050956,1);
		pin(39.025,40.225,96.3461592048026,1);
		pin(39.025,40.225,40.9615438201872,1);
		pin(40.225,41.425,324.736865972215,1);
		pin(40.225,41.425,269.3522505876,1);
		pin(40.225,41.425,203.583019818369,1);
		pin(40.225,41.425,148.198404433754,1);
		pin(40.225,41.425,103.198404433754,1);
		pin(40.225,41.425,85.8907121260616,1);
		pin(40.225,41.425,30.5060967414462,1);
		pin(41.8,43,293.465502746317,1);
		pin(41.8,43,258.850118130932,1);
		pin(41.8,43,172.311656592471,1);
		pin(41.8,43,137.696271977086,1);
		pin(41.8,43,92.6962719770862,1);
		pin(41.8,43,44.2347335155478,1);
		pin(41.8,43,26.9270412078554,1);
		pin(43,44.2,341.865057944014,1);
		pin(43,44.2,321.095827174784,1);
		pin(43,44.2,296.865057944014,1);
		pin(43,44.2,279.557365636322,1);
		pin(43,44.2,220.711211790168,1);
		pin(43,44.2,199.941981020937,1);
		pin(43,44.2,175.711211790168,1);
		pin(43,44.2,158.403519482476,1);
		pin(43,44.2,106.480442559399,1);
		pin(43,44.2,47.6342887132452,1);
		pin(44.625,45.825,327.912835109407,1);
		pin(44.625,45.825,310.605142801714,1);
		pin(44.625,45.825,289.835912032484,1);
		pin(44.625,45.825,265.605142801714,1);
		pin(44.625,45.825,206.758988955561,1);
		pin(44.625,45.825,189.451296647868,1);
		pin(44.625,45.825,168.682065878637,1);
		pin(44.625,45.825,144.451296647868,1);
		pin(44.625,45.825,89.0666812632528,1);
		pin(45.825,47.025,331.319797861829,1);
		pin(45.825,47.025,269.012105554137,1);
		pin(45.825,47.025,210.165951707983,1);
		pin(45.825,47.025,147.858259400291,1);
		pin(45.825,47.025,109.781336323368,1);
		pin(47.355,48.555,300.076899493913,1);
		pin(47.355,48.555,261.99997641699,1);
		pin(47.355,48.555,178.923053340067,1);
		pin(47.355,48.555,140.846130263144,1);
		pin(47.355,48.555,50.8461302631442,1);
		pin(48.555,49.755,341.566750456458,1);
		pin(48.555,49.755,310.412904302612,1);
		pin(48.555,49.755,279.259058148766,1);
		pin(48.555,49.755,189.259058148766,1);
		pin(48.555,49.755,158.10521199492,1);
		pin(50.115,51.315,320.716611944293,1);
		pin(50.115,51.315,289.562765790447,1);
		pin(50.115,51.315,220.331996559677,1);
		pin(50.115,51.315,168.408919636601,1);
		pin(50.115,51.315,36.870458098139,1);
		pin(51.315,52.515,199.519244156118,1);
		pin(55.7,56.9,320.493303692499,1);
		pin(55.7,56.9,289.339457538653,1);
		pin(55.7,56.9,168.185611384807,1);

		title("STAR WARS",1);


	}
}

// Create the blank, ready for dynamically added pins
module createBlank() {

	difference() {
	
		// stock
		cylinder(h=hStock, r=rStock);
	
		// top cutout
		translate(v = [0,0,hStock-hInset+overlap]) {
			cylinder(h=hInset + overlap, r=rInset);
		}

		// Bottom cutout lets the disc sit flatter, but some printers my struggle with the overhang
		translate(v = [0,0,-overlap]) {
			cylinder(h=hInset + overlap, r=rInset);
		}
		
		// Centre hole
		cylinder(h=hStock, r=3.22);

		// Drive holes
		translate(v = [0,oDrive,0]) { cylinder(h=hStock, r=rDrive); }
		translate(v = [0,-oDrive,0]) { cylinder(h=hStock, r=rDrive); }
		translate(v = [oDrive,0,0]) { cylinder(h=hStock, r=rDrive); }
		translate(v = [-oDrive,0,0]) { cylinder(h=hStock, r=rDrive); }

		// Tracks - each one for two notes
		track(28.15, 0);
		track(30.89, 0);
		track(33.71, 0);
		track(36.425, 0);
		track(39.225, 0);
		track(42, 0);
		track(44.825, 0);
		track(47.555, 0);
		track(50.315, 0);
		track(53.11, 0);
		track(55.9, 0);

		if (hasSecondSide > 0) {
			track(28.15, 1);
			track(30.89, 1);
			track(33.71, 1);
			track(36.425, 1);
			track(39.225, 1);
			track(42, 1);
			track(44.825, 1);
			track(47.555, 1);
			track(50.315, 1);
			track(53.11, 1);
			track(55.9, 1);
		}
	}
}

// Negative for a double track
module track(inner, onSecondSide) {
	if (onSecondSide > 0) {
		translate(v = [0,0,-overlap]) {
			difference() {
				cylinder(h=hGroove+overlap, r=inner+2);
				cylinder(h=hGroove+overlap, r=inner);
			}
		}
	}
	else {
		translate(v = [0,0,hStock-hGroove]) {
			difference() {
				cylinder(h=hGroove+overlap, r=inner+2);
				cylinder(h=hGroove+overlap, r=inner);
			}
		}
	}

}

// Create a pin at a certain angle
module pin(inner, outer, angle, onSecondSide)
{
	rotate(a=angle) {
		if (onSecondSide > 0) {
			translate(v=[inner, -0.5, - overlap]) {
				# cube (size=[outer-inner, 1 ,hGroove + overlap], center=false);
			}
		} else {
			translate(v=[inner, -0.5, hStock - hGroove - overlap]) {
				# cube (size=[outer-inner, 1 ,hGroove + overlap], center=false);
			}
		}
	}
}

// Add text
module title(text, onSecondSide)
{
	if (onSecondSide>0)
		writecylinder(text, [0,0,-hInset], radius=20, height=hStock-hInset, h=3, t=hInset, face="bottom");
	else
		writecylinder(text, [0,0,0], radius=20, height=hStock-hInset, h=3, t=hInset, face="top");
}

// Do the work
createDisc();
